#!/bin/sh
PATH=/usr/local/bin:/usr/local/sbin:/usr/bin:/usr/sbin:/bin:/sbin

C_FAL_EVENTLOG="/mnt/data/bin/fal_eventlog.py"
C_FAL_BUZZER="/mnt/data/bin/fal_buzzer.py"

MSG_FIRMWARE_UPDATE_START="37000001"
MSG_FIRMWARE_SUCCESS_FIRMWARE="37000003"
ERR_FIRMWARE_FAIL_FIRMWARE="37040001"

BG_PROCESS_END_MELODY="bgprocessend"
ERROR_MELODY="error"


request_to_fal()
{
        local fal_cmd="$1"
        local entry="$2"

        local request="<request><entrylist>$entry</entrylist></request>"

        echo "$request" | $fal_cmd
}


add_eventlog()
{
        local code="$1"
	local arg_name="$2"
	local arg_val="$3"
        local entry="<entry type=\"add\"><eventlog><log><code>${code}</code><arglist><arg name=\"${arg_name}\">${arg_val}</arg></arglist></log></eventlog></entry>"
        local response=$(
                request_to_fal "${C_FAL_EVENTLOG}" "${entry}" | \
                        grep "result=\"0\"" | \
                        wc -l
        )

        if [ "x${response}" != "x0" ]; then
                return 0
        fi

        return 1
}


play_melody()
{
	local type="${1}"
	local entry="<entry type=\"play\"><buzzer><melody type=\"${type}\"/></buzzer></entry>"
	local response=$(
                request_to_fal "${C_FAL_BUZZER}" "${entry}" | \
                        grep "result=\"0\"" | \
                        wc -l
        )

        if [ "x${response}" != "x0" ]; then
                return 0
        fi

        return 1
}


#####################################
script_dir=$(cd "$(dirname "$0")"; pwd)

ver_str="icc_objlock_fix_2"

add_eventlog "${MSG_FIRMWARE_UPDATE_START}"

/usr/local/bin/remount_root_write

if [ -d /usr/local/lib/python2.7/dist-packages/landiskaccess ]; then
	cp $script_dir/amazons3access.py /usr/local/lib/python2.7/dist-packages/landiskaccess
	python /usr/local/lib/python2.7/dist-packages/landiskaccess/amazons3access.py
	result=${?}


	cp $script_dir/auth.py /usr/local/lib/python2.7/dist-packages/boto
	python /usr/local/lib/python2.7/dist-packages/boto/auth.py

	cp $script_dir/connection.py /usr/local/lib/python2.7/dist-packages/boto
	python /usr/local/lib/python2.7/dist-packages/boto/connection.py

	cp $script_dir/s3_connection.py \
		/usr/local/lib/python2.7/dist-packages/boto/s3/connection.py
	python /usr/local/lib/python2.7/dist-packages/boto/s3/connection.py
else
	cp $script_dir/amazons3access.py /usr/local/lib/python2.6/dist-packages/landiskaccess
	python /usr/local/lib/python2.6/dist-packages/landiskaccess/amazons3access.py
	result=${?}


	cp $script_dir/auth.py /usr/local/lib/python2.6/dist-packages/boto
	python /usr/local/lib/python2.6/dist-packages/boto/auth.py

	cp $script_dir/connection.py /usr/local/lib/python2.6/dist-packages/boto
	python /usr/local/lib/python2.6/dist-packages/boto/connection.py

	cp $script_dir/s3_connection.py \
		/usr/local/lib/python2.6/dist-packages/boto/s3/connection.py
	python /usr/local/lib/python2.6/dist-packages/boto/s3/connection.py
fi

/usr/local/bin/remount_root_read_only

if [ ${result} -eq 0 ]; then
	play_melody "${BG_PROCESS_END_MELODY}"
	add_eventlog "${MSG_FIRMWARE_SUCCESS_FIRMWARE}" version "${ver_str}"
else
	play_melody "${ERROR_MELODY}"
	add_eventlog "${ERR_FIRMWARE_FAIL_FIRMWARE}"
fi
